/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting;

import java.util.ArrayList;
import java.util.HashMap;
import libsidutils.fingerprinting.fingerprint.Fingerprint;
import libsidutils.fingerprinting.fingerprint.Hash;
import libsidutils.fingerprinting.fingerprint.Link;
import libsidutils.fingerprinting.model.Match;
import libsidutils.fingerprinting.model.SongMatch;
import libsidutils.fingerprinting.rest.FingerPrintingDataSource;
import libsidutils.fingerprinting.rest.beans.HashBean;
import libsidutils.fingerprinting.rest.beans.HashBeans;
import libsidutils.fingerprinting.rest.beans.IntArrayBean;

public class Index {
    private FingerPrintingDataSource fingerPrintingDataSource;
    private long maxId = -1L;
    private int maxCount = -1;
    private int maxTime = -1;
    private HashMap<Long, Match> hashMap = new HashMap(400000);

    public void setFingerPrintingClient(FingerPrintingDataSource fingerPrintingClient) {
        this.fingerPrintingDataSource = fingerPrintingClient;
    }

    public SongMatch search(Fingerprint fp, int minHit) {
        ArrayList<Link> linkList = fp.getLinkList();
        Integer[] linkHash = new Integer[linkList.size()];
        Integer[] linkTime = new Integer[linkList.size()];
        for (int i = 0; i < linkHash.length; ++i) {
            linkHash[i] = Hash.hash(linkList.get(i));
            linkTime[i] = linkList.get(i).getStart().getIntTime();
        }
        return this.search(linkTime, linkHash, minHit);
    }

    private SongMatch search(Integer[] linkTime, Integer[] linkHash, int minHit) {
        HashMap<Integer, Integer> linkHashMap = new HashMap<Integer, Integer>(linkHash.length);
        for (int i = 0; i < linkHash.length; ++i) {
            linkHashMap.put(linkHash[i], linkTime[i]);
        }
        IntArrayBean intArray = new IntArrayBean(linkHash);
        HashBeans res = this.fingerPrintingDataSource.findHashes(intArray);
        if (res != null) {
            for (HashBean hashBean : res.getHashes()) {
                int hash2 = hashBean.getHash();
                int id = hashBean.getId();
                int time = hashBean.getTime();
                Long idHash = Index.idHash(id, (Integer)linkHashMap.get(hash2) - time);
                Match count = this.hashMap.get(idHash);
                if (count == null) {
                    count = new Match(0, (Integer)linkHashMap.get(hash2) - time);
                }
                count.updateCount();
                this.hashMap.put(idHash, count);
            }
        }
        this.hashMap.forEach((hash, countTime) -> {
            if (countTime.getCount() > minHit && countTime.getCount() > this.maxCount) {
                this.maxId = hash;
                this.maxCount = countTime.getCount();
                this.maxTime = countTime.getTime();
            }
        });
        Integer offset = -this.maxTime;
        return new SongMatch(Index.hash2id(this.maxId), this.maxCount, offset);
    }

    private static Long idHash(int id, int time) {
        return ((long)id << 16) + (long)time + 32768L;
    }

    private static int hash2id(long idHash) {
        return (int)(idHash >> 16);
    }
}

